/*
 *  linux/arch/arm/mach-uniphier/pm.c
 *
 *  Copyright (C) 2012 Panasonic Corporation
 *  - Derived from arch/arm/mach-omap2/pm44xx.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/pm.h>
#include <linux/suspend.h>
#include <linux/module.h>
#include <linux/list.h>
#include <linux/err.h>
#include <linux/slab.h>

#include <mach/powerdomain.h>

extern int uniphier_enter_lowpower(unsigned int, unsigned int);
extern int __init uniphier_lowpower_init(void);

struct power_state {
	struct powerdomain *pwrdm;
	u32 next_state;
#ifdef CONFIG_SUSPEND
	u32 saved_state;
	u32 saved_logic_state;
#endif
	struct list_head node;
};

static LIST_HEAD(pwrst_list);

#ifdef CONFIG_SUSPEND
static int uniphier_pm_suspend(void)
{
	u32 cpu_id = smp_processor_id();

	uniphier_enter_lowpower(cpu_id, PWRDM_POWER_OFF);

	pr_info("Successfully put all powerdomains to target state\n");

	return 0;
}

static int uniphier_pm_enter(suspend_state_t suspend_state)
{
	int ret = 0;

	switch (suspend_state) {
	case PM_SUSPEND_STANDBY:
	case PM_SUSPEND_MEM:
		ret = uniphier_pm_suspend();
		break;
	default:
		ret = -EINVAL;
	}

	return ret;
}

static int uniphier_pm_begin(suspend_state_t state)
{
	disable_hlt();
	return 0;
}

static void uniphier_pm_end(void)
{
	enable_hlt();
	return;
}

static struct platform_suspend_ops uniphier_pm_ops = {
	.begin		= uniphier_pm_begin,
	.end		= uniphier_pm_end,
	.enter		= uniphier_pm_enter,
	.valid		= suspend_valid_only_mem,
};
#endif /* CONFIG_SUSPEND */

static int __init uniphier_pm_init(void)
{
	int ret;

	pr_err("Power Management for Panasonic UniPhier.\n");

	ret = uniphier_lowpower_init();
	if (ret) {
		pr_err("Failed to initialise Lowpower module\n");
		goto err2;
	}

#ifdef CONFIG_SUSPEND
	suspend_set_ops(&uniphier_pm_ops);
#endif /* CONFIG_SUSPEND */

err2:
	return ret;
}
late_initcall(uniphier_pm_init);
